/*
 * Title  : user_info.sql
 * Author : EXADIME LLC
 * Created: 04-Dec-2020
 * Updated: 04-Dec-2020
 * Release: 1.0.0
 * Purpose: Shows details of the given user.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 200
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno				format 99		heading "#"
col "User Name"			format a25
col "Default Tablespace"	format a25
col "Temporary Tablespace"	format a25
col "Profile"			format a25
col "Created"			format a10
col "Last Login"                format a20
col "Status"		        format a16

accept p_user char prompt "Enter Username: "

spool &&rpt_dir/user_info.rpt

select 
	rownum						sno,
	username					"User Name",
	default_tablespace				"Default Tablespace",
	temporary_tablespace				"Temporary Tablespace",
	profile						"Profile",
	created						"Created",
	to_char(last_login,'DD-MON-YYYY HH24:MI')       "Last Login",
	account_status 					"Status"
from
	dba_users
where
	username=upper('&&p_user');

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
