/*
 * Title  : sho_gg_cap.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 07-Oct-2020
 * Release: 1.0.0
 * Purpose: Shows Golden Gate capture details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"			format 9999
col "Capture Name"      format a20
col "Captured SCN"      format 99999999999999
col "Applied SCN"	format 99999999999999
col "Oldest SCN"	format 99999999999999

accept p_order char prompt "Enter order by column {1|2|3|4|5} [asc|desc] " default 2

spool &&rpt_dir/sho_gg_cap.rpt

select
	row_number() over(order by &&p_order)         "#",
	capture_name                                  "Capture Name",
	captured_scn                                  "Captured SCN",
	applied_scn                                   "Applied SCN",
	oldest_scn                                    "Oldest SCN"
from (
	select
		capture_name,
		captured_scn,
		applied_scn,
		oldest_scn
	from
		dba_capture
)
order by
	&&p_order
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
