/*
 * Title  : sho_dba_dir.sql
 * Author : EXADIME LLC
 * Created: 18-Aug-2021
 * Updated: 10-Oct-2024
 * Release: 1.0.0
 * Purpose: Shows DBA directories.
 * History: Added filter.
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno		format 9999     heading "#"
column owner		format a20	heading "Owner"
column directory_name	format a30	heading "Directory Name"
column directory_path	format a80	heading "Directory Path"

accept p_txt char prompt "Enter search string (E.g. DUMP): "
accept p_order char prompt "Enter order by column {1|2|3} [asc|desc] " default 2,3

spool &&rpt_dir/sho_dba_dir.rpt

select 
	row_number() over(order by &&p_order) sno,
	owner,
	directory_name,
	directory_path
from (
	select 
		owner,
		directory_name,
		directory_path 
	from 
		dba_directories
	where
		(owner like upper('%&&p_txt%') or directory_name like upper('%&&p_txt%') or directory_path like upper('%&&p_txt%'))
) order by
	&&p_order
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off