/*
 * Title  : sho_db_link.sql
 * Author : EXADIME LLC
 * Created: 25-Sep-2023
 * Updated: 03-Jun-2025
 * Release: 1.0.0
 * Purpose: Shows available database links in the database.
 * Comment: Works from 18c or above.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 200
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col sno		format 999	heading "#"
col owner	format a25	heading "Owner"
col db_link	format a25	heading "Link"
col username	format a25	heading	"User"
col host	format a25	heading "Host"
col created	format a10	heading "Created"
col shard	format a6	heading "Shard?"
col hidden	format a7	heading "Hidden?"
col valid	format a6	heading "Valid?"

accept p_txt char prompt "Enter search string (E.g. Owner/Link): "
accept p_order_col char prompt "Enter order by column {1|2|3|4|5|6|7|8} [asc|desc] " default 2,3,4

spool &&rpt_dir/sho_db_link.rpt

select 
	row_number() over(order by &&p_order_col)	sno,
	owner,
	db_link,
	username,
	substr(host,1,25) host,
	created,
	shard_internal shard,
	hidden,
	valid
from (
	select
		owner,
		db_link,
		username,
		host,
		created,
		shard_internal,
		hidden,
		valid
	from
		dba_db_links
) where
	(owner like upper('%&&p_txt%') or db_link like upper('%&&p_txt%') or username like upper('%&&p_txt%'))
order by
	&&p_order_col
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
