/*
 * Title  : sch_inv_obj.sql
 * Author : EXADIME LLC
 * Created: 10-Aug-2021
 * Updated: 10-Aug-2021
 * Release: 1.0.0
 * Purpose: This script shows invalid objects for the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 120
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Owner" format a30
col "Object Type" format a30
col "Object Name" format a30
col "Status" format a7
col "Time Stamp" format a19

accept p_schema char prompt "Enter schema name "
accept p_order char prompt "Enter order by column {1|2|3|4|5} [asc|desc] " default 1,2,3

spool &&rpt_dir/sch_inv_obj.rpt

select 
	owner					"Owner",
	object_type				"Object Type",
	object_name				"Object Name",
	status					"Status",
	timestamp				"Time Stamp"
from	
	dba_objects 
where	
	owner in (
		upper('&p_schema')
	)
and	object_name not like 'BIN$%'
and	status='INVALID'
order by
	&&p_order;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
