/*
 * Title  : sch_ena_con.sql
 * Author : EXADIME LLC
 * Created: 30-Mar-2018
 * Updated: 30-Mar-2018
 * Release: 1.0.0
 * Purpose: To enable constraints in the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept sch_name char prompt 'Enter Schema Name: '

spool &&tmp_dir/sch_ena_con.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/sch_ena_con.rpt
prompt

select
	'ALTER TABLE ' || owner || '.' || table_name || 
	' ENABLE CONSTRAINT ' || constraint_name || chr(10) || '/'
from
	dba_constraints
where
	owner=upper('&&sch_name')
and	status='DISABLED'
order by
	owner,constraint_type
/

prompt spool off

spool off

prompt Run the script "&&tmp_dir/sch_ena_con.tmp" manually.
prompt

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
