/*
 * Title  : run_tune_task.sql
 * Author : EXADIME LLC
 * Created: 29-Mar-2018
 * Updated: 29-Mar-2018
 * Release: 1.0.0
 * Purpose: To run SQL Tuning Advisor and report recommendations.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 200
set pagesize 1000
set pause off
set long 65536

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_sql_id char prompt "Enter SQL Id "

spool &&rpt_dir/run_tune_task.rpt

declare
	sql_tune_task_id  varchar2(100);
begin
	sql_tune_task_id := dbms_sqltune.create_tuning_task(
                          sql_id      => '&&p_sql_id',
                          scope       => dbms_sqltune.scope_comprehensive,
                          time_limit  => 1000,
                          task_name   => 'sql_tune_task_&&p_sql_id',
                          description => 'Tuning task for statement &&p_sql_id');
	dbms_output.put_line('SQL Tune Task Id: ' || sql_tune_task_id);
end;
/

exec dbms_sqltune.execute_tuning_task(task_name => 'sql_tune_task_&&p_sql_id');

select 
	dbms_sqltune.report_tuning_task('sql_tune_task_&&p_sql_id') 
from 
	dual;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
