/*
 * Title  : dg_soft_fail.sql
 * Author : EXADIME LLC
 * Created: 20-Sep-2024
 * Updated: 20-Sep-2024
 * Release: 1.0.0
 * Purpose: To graceful failover standby db to primary.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

spool &&rpt_dir/dg_sof_fail.rpt

declare
	mrp	number;
begin
	select
		count(1) into mrp
	from
        	gv$managed_standby
	where
		process like 'MRP%';
if mrp>0 then
	execute immediate 'alter database recover managed standby database cancel';
	dbms_output.put_line('Cancelled managed recovery process.');
end if;
end;
/

set feedback on
set echo on

alter database recover managed standby database finish;
alter database commit to switchover to primary with session shutdown;
shutdown immediate;
startup;

set echo off

spool off;

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
