/*
 * Title  : awr_wait_hist.sql
 * Author : EXADIME LLC
 * Created: 31-Jan-2023
 * Updated: 31-Jan-2023
 * Release: 1.0.0
 * Purpose: History of given wait event captured in awr.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column snid	format 999999		heading "SnapId"
column ss	format a15		heading "Snap Start Time"
column se	format a15		heading "Snap End Time"
column en	format a40		heading "Event Name"
column tw	format 999,999,999	heading "Total Waits"
column wt	format 999,999,999	heading "Time(s)"
column awt	format 999,999,999	heading "Avg wait(ms)"
column dbt	format 9,999,999	heading "% DB Time"
column wc	format a15		heading "Wait Class"

accept p_bs prompt "Enter begin snap id: "
accept p_es prompt "Enter end snap id: "
accept p_wait prompt "Enter wait event name: "

spool &&rpt_dir/awr_wait_hist.rpt

select 
	case wait_rank when 1 then snap_id end snid,
	case wait_rank when 1 then begin_snap end ss,
	case wait_rank when 1 then end_snap end se,
	event_name en,
	total_waits tw,
	time_waited wt,
	round((time_waited/total_waits)*1000) awt,
	round((time_waited/db_time)*100, 2) dbt,
	substr(wait_class, 1, 15) wc
from (
	select
		inst_id,
		snap_id, 
		to_char(begin_snap, 'YYYYMMDD HH24:MI') begin_snap,
		to_char(end_snap, 'YYYYMMDD HH24:MI') end_snap,
		event_name,
		wait_class,
		total_waits,
		time_waited,
		dense_rank() over (partition by inst_id, snap_id order by time_waited desc)-1 wait_rank,
		max(time_waited) over (partition by inst_id, snap_id) db_time
	from (
		select
			s.instance_number inst_id,
			s.snap_id,
			s.begin_interval_time begin_snap,
			s.end_interval_time end_snap,
			event_name,
			wait_class,
			total_waits-lag(total_waits, 1, total_waits) over
			(partition by s.startup_time, s.instance_number, stats.event_name order by s.snap_id) total_waits,
			time_waited-lag(time_waited, 1, time_waited) over
			(partition by s.startup_time, s.instance_number, stats.event_name order by s.snap_id) time_waited,
			min(s.snap_id) over (partition by s.startup_time, s.instance_number, stats.event_name) min_snap_id
		from (
			select 
				dbid, instance_number, snap_id, event_name, wait_class, total_waits_fg total_waits, round(time_waited_micro_fg/1000000, 2) time_waited
			from 
				dba_hist_system_event
			where 
				wait_class not in ('Idle', 'System I/O')
			union all
			select 
				dbid, instance_number, snap_id, stat_name event_name, null wait_class, null total_waits, round(value/1000000, 2) time_waited
			from 
				dba_hist_sys_time_model
			where stat_name in ('DB CPU', 'DB time')
		)	stats, 
			dba_hist_snapshot s
		where 
			stats.instance_number=s.instance_number
		and	stats.snap_id=s.snap_id
		and	stats.dbid=s.dbid
		and	s.instance_number=1
		and	stats.snap_id between &p_bs and &p_es
	) 
	where 
		snap_id > min_snap_id and nvl(total_waits,1) > 0
)
where	
	event_name='&&p_wait'
order by 
	inst_id, snap_id;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
