/*
 * Title  : awr_tab_io.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Table i/o history captured in awr.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum	format 9999		heading "#"
column snid	format 999999		heading "SnapId"
column inst	format 9999		heading "Node"
column time	format a15		heading "Time"
column dlr	format 999,999,999	heading "Logical Reads"
column dpr	format 999,999,999	heading "Physical Reads"
column dpw	format 999,999,999	heading "Delta|Physical Writes"

accept p_sch char prompt "Enter schema name: "
accept p_tab char prompt "Enter table name: "
accept p_days char prompt "Enter number of days: "

spool &&rpt_dir/awr_tab_io.rpt

select
	rownum,
	snid,
	time,
	inst,
	dlr,
	dpr,
	dpw
from 
	(
		select
			sn.snap_id						snid,
			to_char(sn.end_interval_time,'yyyymmdd hh24:mi')	time,
			sn.instance_number					inst,
			logical_reads_delta					dlr,
			physical_reads_delta					dpr,
			physical_writes_delta					dpw
		from
			dba_hist_snapshot sn,
			dba_hist_seg_stat ss,
			dba_objects do
		where
			sn.snap_id=ss.snap_id
		and	sn.instance_number=ss.instance_number
		and	ss.obj#=do.object_id
		and	do.owner='&p_sch'
		and	do.object_name='&p_tab'
		and	sn.begin_interval_time>sysdate-&p_days
		order by 
			sn.snap_id desc,
			sn.instance_number
	)
order by
	1;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off