/*
 * Title  : awr_set_ret.sql
 * Author : EXADIME LLC
 * Created: 24-Oct-2016
 * Updated: 04-Apr-2018
 * Release: 1.0.0
 * Purpose: To set AWR retention period.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_ret prompt "Enter Retention (Day): "
accept p_int prompt "Enter Interval (Min): "

spool &&rpt_dir/awr_set_ret.rpt

BEGIN
	DBMS_WORKLOAD_REPOSITORY.modify_snapshot_settings(
		retention => &&p_ret*24*60,
		interval  => &&p_int
	);
END;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
