/*
 * Title  : us_ts.sql
 * Author : EXADIME LLC
 * Created: 01-Aug-2017
 * Updated: 12-Apr-2018
 * Release: 1.0.0
 * Purpose: The following script shows mapping between users and tablespaces.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "User Name"		format a30
col "TSD"		format a42	heading "Tablespace Name	                Contents"

break on "User Name"

spool &&rpt_dir/us_ts.rpt

select
	distinct
	usn					"User Name",
	rpad(tsn,30)	
	|| ' [' 
	||
	(
		select
			contents
		from
			dba_tablespaces
		where
			tablespace_name=tsn
	)		
	|| ']' 					"TSD"
from 
	(
		select
			owner			usn,
			tablespace_name		tsn
		from
			dba_extents
		union
		select
			username		usn,
			default_tablespace	tsn
		from
			dba_users
		union
		select
			username		usn,
			temporary_tablespace	tsn
		from
			dba_users
	)		
order by
	1,2
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
