/*
 * Title  : stat_job_hist.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 03-Dec-2018
 * Release: 1.0.0
 * Purpose: Shows auto statistics gathering job history.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 170
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"			format 9999
col "Job Name"		format a25
col "Window Name"	format a20
col "Start Time"	format a20
col "Job Duration"	format a15
col "Status"		format a10
col "Job Information"	format a60

accept p_txt char prompt "Enter search string (E.g. Window Name/Status): "
accept p_top	prompt "Enter top rows [10]: " default 10;

spool &&rpt_dir/stat_job_hist.rpt

select
	row_number() over(order by 1)			"#",
	job_name					"Job Name",
	window_name					"Window Name",
	to_char(job_start_time,'dd-mon-yyyy hh:mi:ss')	"Start Time",
	job_duration					"Job Duration",
	job_status					"Status",
	substr(job_info,1,60)				"Job Information"
from (
	select
		job_name,
		window_name,
		job_start_time,
		job_duration,
		job_status,
		job_info
	from
		dba_autotask_job_history
	where
		client_name='auto optimizer stats collection'
	and	(window_name like upper('%&&p_txt%') or job_status like upper('%&&p_txt%'))
	and	rownum<=&&p_top
	order by
		job_start_time desc
);

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
