/*
 * Title  : sho_ts_hwm.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: High water mark in given tablespace.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column id	format 9,999,999	heading "File ID"
column name	format a60		heading "File Name"
column total	format 99,999,999,999	heading "Total"
column occupied	format 99,999,999,999	heading "Occupied"
column hwm	format 99,999,999,999	heading "KBytes|High Water Mark"
column auto	format a5		heading "Auto?"

compute sum of total	on report
compute sum of occupied on report
compute sum of hwm 	on report

break on report

accept p_ts_name char prompt "Enter Tablespace Name "

spool &&rpt_dir/sho_ts_hwm.rpt

select  
	f.file_id						fid,
	file_name						name,
	decode(autoextensible,'YES',maxbytes/1024,bytes/1024)	total,
	bytes/1024						occupied,
	nvl(ceil((nvl(e.hwm, 0) * (select block_size from dba_tablespaces t,dba_data_files d where t.tablespace_name=d.tablespace_name and f.file_id=e.file_id and rownum<=1))/1024),0) as hwm,
	autoextensible						auto
from
	dba_data_files f
left join(
		select 
			file_id, 
			max(block_id + blocks - 1) hwm 
		from 
			dba_extents 
		group by 
			file_id
	) e on f.file_id = e.file_id
where
	f.tablespace_name = upper('&&p_ts_name')
order by
	f.file_id
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off