/*
 * Title  : sho_tde_wall.sql
 * Author : EXADIME LLC
 * Created: 05-Jan-2021
 * Updated: 28-Jul-2022
 * Release: 1.0.0
 * Purpose: To display TDE wallet details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum              format 99       heading "#"
col wrl_type            format a10      heading "Type"
col wrl_parameter       format a60      heading "Location"
col wallet_type         format a10      heading "Type"
col status              format a30      heading "Status"

spool &&rpt_dir/sho_tde_wall.rpt

select 
	rownum,
	wrl_type,
	wrl_parameter,
	wallet_type,
	status
from 
	v$encryption_wallet;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off