/*
 * Title  : del_dat.sql
 * Author : EXADIME LLC
 * Created: 31-Jul-2017
 * Updated: 23-Mar-2018
 * Release: 1.0.0
 * Purpose: Deletes rows in the current schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

prompt rem Disable all the constraints before you run this script 

spool &&tmp_dir/del_dat.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/del_dat.rpt
prompt

select
	'DELETE ' || table_name || chr(10) || '/'
from
	user_tables
/

prompt
prompt spool off

spool off

prompt Run the script "&&tmp_dir/del_dat.tmp" manually.
prompt

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
